/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.position_tests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import com.ordana.immersive_weathering.mixins.accessors.BiomeAccessor;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;

record TemperatureMatchTest(float max, float min, boolean useLocalPos) implements IPositionRuleTest
{
    public static final String NAME = "temperature_range";
    private static final Codec<TemperatureMatchTest> C = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(g -> Float.valueOf(g.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(g -> Float.valueOf(g.max)), (App)Codec.BOOL.optionalFieldOf("use_local_pos", (Object)true).forGetter(TemperatureMatchTest::useLocalPos)).apply((Applicative)instance, TemperatureMatchTest::new)).comapFlatMap(t -> {
        if (t.max < t.min) {
            return DataResult.error((String)("Max must be at least min, min_inclusive: " + t.min + ", max_inclusive: " + t.max));
        }
        return DataResult.success((Object)t);
    }, Function.identity());
    static final IPositionRuleTest.Type<TemperatureMatchTest> TYPE = new IPositionRuleTest.Type<TemperatureMatchTest>(C, "temperature_range");

    public IPositionRuleTest.Type<TemperatureMatchTest> getType() {
        return TYPE;
    }

    @Override
    public boolean test(Supplier<class_6880<class_1959>> biome, class_2338 pos, class_1937 level) {
        float temp = level.method_8597().comp_644() ? 3.0f : (this.useLocalPos ? ((BiomeAccessor)biome.get().comp_349()).invokeGetTemperature(pos) : ((class_1959)biome.get().comp_349()).method_8712());
        return temp >= this.min && temp <= this.max;
    }
}

